'''
用来进行梯度剪裁、添加噪声、计算隐私预算
'''

import torch
import numpy as np
import random
import math
#noise_scale = 0.2#0.05, 0.1, 0.15, 0.2,0.25 when C=1
#C = 1#0.5, 0.3, 0.1, 0.05, 0.01
#std = noise_scale

def clipping(gradients, Fclip, clip_norm, layers,C):
    
    l2_norm = torch.norm(gradients)
    # print("l2_norm:", l2_norm)
    if Fclip == False:
        clip_norm = l2_norm
        clip_value = C/math.sqrt(layers)
    else:
        clip_value = C

    clipped_gradients = gradients / max(1, clip_norm / clip_value)
    return l2_norm, clipped_gradients

def adding_noise(gradients,C,std):
    #在CDP场景下，噪声的方差sigma=noise_multiplier*S（敏感度，也就是本代码里面的C）/len(selected)
    
    GaussianNoises = torch.normal(mean=0.0, std=C * std, size=gradients.shape, dtype=gradients.dtype, device=gradients.device)
    #print(len(gradients))
    gradients=gradients+GaussianNoises
    #print(gradients)
    return gradients
